<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  Conversion d'une reponse du WebdavGenerator en lments inJac
  comportement: 
  si vide, @title est remplac par @name
-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:collection="http://apache.org/cocoon/collection/1.0"
		xmlns:MD="http://esup-portail.org/injac">

<xsl:param name="currentloc"/>
<xsl:param name="backUri"/>
<xsl:param name="upnode"/>

<xsl:template match="/MD:response">
<xsl:variable name="directory-title">
	<xsl:choose>
		<xsl:when test="MD:resource[@name=/MD:response/@directory]/@title != ''">
			<xsl:value-of select="MD:resource[@name=/MD:response/@directory]/@title"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="MD:resource[@name=/MD:response/@directory]/@name"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:variable>	
<injacNavPan>  
  <current>
    <name>
    	<xsl:value-of select="$directory-title"/>
    </name>
  </current>
  <spaces parent="{$currentloc}/" parent-title="{$directory-title}">
  <!-- boucle sur tous les rpertoires  l'exclusion du parent -->
  <xsl:for-each select="*[@resourcetype='D'][@name!=/MD:response/@directory][@injac-type='space']">
  <space>
  	<name>
    		<xsl:value-of select="@name"/>
    	</name>
  	
  	<lastModified>
    		<xsl:value-of select="@getlastmodified"/>
    	</lastModified>
	<date>
    		<xsl:value-of select="@creationdate"/>
    	</date>
	<size>
    		<xsl:value-of select="@getcontentlength"/>
    	</size>
	<title>
		<xsl:choose>
			<xsl:when test="@title!=''">
				<xsl:value-of select="@title"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@name"/>
			</xsl:otherwise>
		</xsl:choose>
		
	</title>
	<root-doc-name>
            <xsl:value-of select="@root-doc-name"/>
        </root-doc-name> 
        <description>
            <xsl:value-of select="@description"/>
        </description>   
  </space> 
  </xsl:for-each>
  </spaces>
  <!-- composites -->
  <documents parent="{$currentloc}" parent-title="{$directory-title}" >
   <xsl:for-each select="*[@resourcetype='D'][@name!=/MD:response/@directory][@injac-type='document']">
   <document>
   	<name><xsl:value-of select="@name"/></name>
	<lastModified>
	    	<xsl:value-of select="@getlastmodified"/>
	</lastModified>
	<date>
		<xsl:value-of select="@creationdate"/>
	</date>
	<size>
	    	<xsl:value-of select="@getcontentlength"/>
	</size>
	<title>
		<xsl:choose>
		<xsl:when test="@title!=''"><xsl:value-of select="@title"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
		</xsl:choose>
	</title>
	<root-file-name><xsl:value-of select="@root-file-name"/></root-file-name>
	<document-state>
		<xsl:value-of select="@document-state"/>
	</document-state>
        <description>
            <xsl:value-of select="@description"/>
        </description>
   </document>
   </xsl:for-each>
  </documents> 
</injacNavPan> 
<injacNavBar>
  	<currentloc>
		<xsl:value-of select="$currentloc" /> 
	</currentloc>
	<current-title>
            <xsl:value-of select="$directory-title"/>
	</current-title>
	<upnode>
		<xsl:value-of select="$upnode" /> 
 	</upnode>
	<backUri>
		<xsl:value-of select="$backUri" /> 
	</backUri>
</injacNavBar>

</xsl:template>
   


</xsl:stylesheet>
